package row_data_gateway;
import db_context.DbContext;
import db_context.MyExceptions;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class TransportFinder {
    private static final TransportFinder INSTANCE = new TransportFinder();

    public static TransportFinder getInstance() {
        return INSTANCE;
    }

    private TransportFinder() {
    }

    public Transport SetTransport(ResultSet r) throws SQLException {
        Transport c = new Transport();
        c.setId(r.getInt("id"));
        c.setRoute(r.getString("route"));
        c.setDeparture_time(r.getTimestamp("departure_time"));
        c.setArrival_time(r.getTimestamp("arrival_time"));
        c.setPackage_id(r.getInt("package_id"));
        c.setStarting_loc_id(r.getInt("starting_loc_id"));
        c.setDestination_loc_id(r.getInt("destination_loc_id"));
        return c;
    }

    public Transport findById(int id) throws SQLException, MyExceptions.NotSuchIdException {

        try (PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT * FROM transports WHERE id = ?")){
            s.setInt(1, id);
            try (ResultSet r = s.executeQuery()) {
                if (r.next()) {
                    Transport c = SetTransport(r);

                    if (r.next()) throw new RuntimeException("Move than one row was returned");
                    return c;
                } else {
                    throw new MyExceptions.NotSuchIdException("Not such transport");
                }
            }
        }
    }

    public List<Transport> findAll() throws SQLException {
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT * FROM transports")) {
            try (ResultSet r = s.executeQuery()) {
                List<Transport> transports = new ArrayList<>();
                while (r.next()) {
                    Transport c =SetTransport(r);
                    transports.add(c);
                }
                return transports;
            }
        }
    }

    public Transport findByPackageId(int id) throws SQLException, MyExceptions.NotSuchIdException {

        try (PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT * FROM transports WHERE package_id = ?")){
            s.setInt(1, id);
            try (ResultSet r = s.executeQuery()) {
                if (r.next()) {
                    Transport c = SetTransport(r);

                    if (r.next()) throw new RuntimeException("Move than one row was returned");
                    return c;
                } else {
                    throw new MyExceptions.NotSuchIdException("Not such package or package wasn't scheduled for transport yet");
                }
            }
        }
    }
}
